#include <bits/stdc++.h>
using namespace std;

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0), cout.tie(0);

    int N;
    cin >> N;

    vector<int> U(N);
    vector<int> V(N);

    struct Soba {
        vector<int> sobe_iznad;
        int broj_iznad = 0;
        bool platforma = true;
    };

    Soba soba[N];

    vector<int> indegree(N, 0); // Broj ulaznih grana za svaki cvor

    for (int i = 0; i < N - 1; i++)
    {
        cin >> U[i] >> V[i];

        soba[U[i] - 1].sobe_iznad.push_back(V[i]);
        soba[U[i] - 1].broj_iznad++;

        soba[V[i] - 1].sobe_iznad.push_back(U[i]); // Update for undirected edge
        soba[V[i] - 1].broj_iznad++;

        indegree[V[i] - 1]++;
        indegree[U[i] - 1]++; // Update for undirected edge
    }

    vector<int> B(N);

    for (int i = 0; i < N; i++)
    {
        cin >> B[i];
        if (B[i] == 1)
        {
            soba[i].platforma = true;
        }
        else
            soba[i].platforma = false;
    }

    vector<int> X(N);

    for (int i = 0; i < N; i++)
    {
        cin >> X[i];
    }

    queue<int> q;
    for (int i = 0; i < N; i++)
    {
        if (indegree[i] == 0)
        {
            q.push(i);
        }
    }

    vector<int> redosled;
    while (!q.empty())
    {
        int cvor = q.front();
        q.pop();

        redosled.push_back(cvor);

        for (int sused : soba[cvor].sobe_iznad)
        {
            indegree[sused - 1]--;
            if (indegree[sused - 1] == 0)
            {
                q.push(sused - 1);
            }
        }
    }

    for (int i = 0; i < N; i++)
    {
        int broj_skokova = 0;

        soba[X[i] - 1].platforma = !soba[X[i] - 1].platforma;
        auto zec = i + 1;
        int index = find(redosled.begin(), redosled.end(), zec) - redosled.begin();

        if ((index == 1) || (index == 0))
            broj_skokova = 1;
        else
        {
            do
            {
                if (soba[redosled[index - 2] - 1].platforma)
                {
                    index -= 2;
                    broj_skokova++;
                }
                else if (soba[redosled[index - 1] - 1].platforma)
                {
                    index -= 1;
                    broj_skokova++;
                }
                else
                {
                    broj_skokova = -1;
                    index = -1;
                }
            } while (index > -1);
        }
        cout << broj_skokova << " ";
    }

    return 0;
}